/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.registry;

import java.util.List;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.config.PathConfig;
import org.betterx.bclib.items.BaseDiscItem;
import org.betterx.bclib.items.BaseDrinkItem;
import org.betterx.bclib.items.BaseSpawnEggItem;
import org.betterx.bclib.items.ModelProviderItem;
import org.betterx.bclib.models.RecordItemModelProvider;
import org.betterx.bclib.recipes.SmithingTemplates;
import org.betterx.bclib.registry.BaseRegistry;
import org.betterx.worlds.together.tag.v3.TagManager;

public class ItemRegistry
extends BaseRegistry<Item> {
    public ItemRegistry(PathConfig config) {
        super(config);
    }

    public Item registerDisc(ResourceLocation itemId, int power, SoundEvent sound, int lengthInSeconds) {
        RecordItem item = BaseDiscItem.create(power, sound, BehaviourBuilders.createDisc(), lengthInSeconds);
        if (item != null) {
            RecordItemModelProvider.add(item);
            if (!this.config.getBoolean("musicDiscs", itemId.m_135815_(), true)) {
                return item;
            }
            this.register(itemId, (Item)item);
            TagManager.ITEMS.add(ItemTags.f_13158_, item);
        }
        return item;
    }

    public SmithingTemplateItem registerSmithingTemplateItem(ResourceLocation id, List<ResourceLocation> baseSlotEmptyIcons, List<ResourceLocation> additionalSlotEmptyIcons) {
        SmithingTemplateItem item = SmithingTemplates.create(id).setBaseSlotEmptyIcons(baseSlotEmptyIcons).setAdditionalSlotEmptyIcons(additionalSlotEmptyIcons).build();
        this.register(new ResourceLocation(id.m_135827_(), id.m_135815_() + "_smithing_template"), (Item)item);
        return item;
    }

    public Item register(ResourceLocation itemId) {
        return this.register(itemId, new ModelProviderItem(this.makeItemSettings()));
    }

    @Override
    public Item register(ResourceLocation itemId, Item item) {
        if (!this.config.getBoolean("items", itemId.m_135815_(), true)) {
            return item;
        }
        this.registerItem(itemId, item);
        return item;
    }

    public Item registerTool(ResourceLocation itemId, Item item) {
        if (!this.config.getBoolean("tools", itemId.m_135815_(), true)) {
            return item;
        }
        this.registerItem(itemId, item);
        return item;
    }

    public Item registerEgg(ResourceLocation itemId, EntityType<? extends Mob> type, int background, int dots) {
        BaseSpawnEggItem item = new BaseSpawnEggItem(type, background, dots, this.makeItemSettings());
        if (!this.config.getBoolean("spawnEggs", itemId.m_135815_(), true)) {
            return item;
        }
        DefaultDispenseItemBehavior behavior = new DefaultDispenseItemBehavior(){

            public ItemStack m_7498_(BlockSource pointer, ItemStack stack) {
                Direction direction = (Direction)pointer.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                EntityType entityType = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
                entityType.m_20592_(pointer.m_7727_(), stack, null, pointer.m_7961_().m_121945_(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
                stack.m_41774_(1);
                return stack;
            }
        };
        DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)behavior);
        return this.register(itemId, (Item)item);
    }

    public Item registerFood(ResourceLocation itemId, int hunger, float saturation, MobEffectInstance ... effects) {
        FoodProperties.Builder builder = new FoodProperties.Builder().m_38760_(hunger).m_38758_(saturation);
        for (MobEffectInstance effect : effects) {
            builder.m_38762_(effect, 1.0f);
        }
        return this.registerFood(itemId, builder.m_38767_());
    }

    public Item registerFood(ResourceLocation itemId, FoodProperties foodComponent) {
        return this.register(itemId, new ModelProviderItem(this.makeItemSettings().m_41489_(foodComponent)));
    }

    public Item registerDrink(ResourceLocation itemId, FoodProperties foodComponent) {
        return this.register(itemId, new BaseDrinkItem(this.makeItemSettings().m_41487_(1).m_41489_(foodComponent)));
    }

    public Item registerDrink(ResourceLocation itemId, int hunger, float saturation) {
        FoodProperties.Builder builder = new FoodProperties.Builder().m_38760_(hunger).m_38758_(saturation);
        return this.registerDrink(itemId, builder.m_38767_());
    }

    @Override
    public void registerItem(ResourceLocation id, Item item) {
        if (item != null && item != Items.f_41852_) {
            Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)id, (Object)item);
            ItemRegistry.getModItems(id.m_135827_()).add(item);
        }
    }

    public Item register(ResourceLocation itemId, Item item, String category) {
        if (this.config.getBoolean(category, itemId.m_135815_(), true)) {
            this.registerItem(itemId, item);
        }
        return item;
    }
}

